export function parseDynamicText(template, valueMap = {}) {
    return template.replace(/\{#(.*?)\}/g, (_, key) => {
        const value = valueMap[key.toLowerCase()] ?? `{#${key}}`;
        return typeof value === "string" || typeof value === "number"
            ? value
            : JSON.stringify(value);
    });
}